<?php

namespace Modules\Supplier\Service;

use Modules\Places\Entities\Place;
use Modules\Suppliers\Entities\Supplier;

/**
 * Class SupplierService
 * @package Modules\Supplier\Service
 */
class SupplierService {

    /**
     * Count of Suppliers according to access rules
     *
     * @return integer
     */
    public function count() {

        if(\Auth::user()->hasRole('admin')){

            return Supplier::count();
        }

        else {

            return Supplier::where('company_id',\Auth::user()->company_id)->count();
        }
    }

    /**
     * Count of Suppliers according to some company
     *
     * @return integer
     */
    public function countByCompany($company_id) {

        return Supplier::where('company_id',$company_id)->count();
    }

}
