<?php

namespace Modules\Suppliers\Http\Controllers;

use Modules\Suppliers\Datatables\SupplierDatatable;
use Modules\Suppliers\Entities\Supplier;
use Modules\Suppliers\Http\Forms\SupplierForm;
use Modules\Suppliers\Http\Requests\SuppliersRequest;
use Modules\Platform\Core\Http\Controllers\ModuleCrudController;

class SuppliersController extends ModuleCrudController
{

    protected $datatable = SupplierDatatable::class;
    protected $formClass = SupplierForm::class;
    protected $storeRequest = SuppliersRequest::class;
    protected $updateRequest = SuppliersRequest::class;
    protected $entityClass = Supplier::class;

    protected $moduleName = 'suppliers';


    protected $jsFiles = [
        'BAP_Suppliers.js',
    ];

    protected $permissions = [
        'browse' => 'suppliers.browse',
        'create' => 'suppliers.create',
        'update' => 'suppliers.update',
        'destroy' => 'suppliers.destroy'
    ];

    protected $moduleSettingsLinks = [];

    protected $settingsPermission = 'suppliers.settings';

    protected $showFields = [

        'information' => [

            'company_id' => [
                'type' => 'hidden',
                'col-class' => 'col-12'
            ],

            'fantasy_name' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],                

            'email' => [
                'type' => 'email',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                                    
            'person_type' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'person_tax_number-company_tax_number' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'responsible_name' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],                    
                
            'phone' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],                    
                
            'mobile' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                    
        ],

        
        'address' => [
                
            'city' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'state' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'street' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'number' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'neighborhood' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'complement' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'postal_code' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            
        ],
        
        'notes' => [
                
            'notes' => [
                'type' => 'text',
                'col-class' => 'col-12'
            ],
                    
        ],


    ];

    protected $languageFile = 'suppliers::suppliers';

    protected $routes = [
        'index' => 'suppliers.suppliers.index',
        'create' => 'suppliers.suppliers.create',
        'show' => 'suppliers.suppliers.show',
        'edit' => 'suppliers.suppliers.edit',
        'store' => 'suppliers.suppliers.store',
        'destroy' => 'suppliers.suppliers.destroy',
        'update' => 'suppliers.suppliers.update'
    ];

    public function __construct()
    {
        parent::__construct();

    }

}
