<html lang="pt">

    <head>
        <meta charset="UTF-8">
        <link href="{!! public_path() !!}/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    </head>

    <body>

        <div class="page-header text-center">

            <h2>
                @lang('reports::reports.pdfReport.report_by_conservation_state') - 
                @if(isset($place))
                    {!! $place->identifier_name !!} 
                @elseif(isset($company))
                    {!! $company->name !!} 
                @else
                    @lang('reports::reports.general_report')
                @endif

            </h2>

        </div>

        <table class="table table-bordered table-striped" style="margin-top: 30px">
            <thead style="display: table-header-group">
                <tr>
                    <th>@lang('reports::reports.pdfReport.asset_number')</th>
                    <th>@lang('reports::reports.pdfReport.area')</th>
                    <th>@lang('reports::reports.pdfReport.category')</th>
                    <th>@lang('reports::reports.pdfReport.conservationState')</th>
                </tr>
            </thead>
            <tbody>
                @foreach($assets as $asset)
                    <tr style="page-break-inside: avoid">
                        <td>{!! $asset['asset_number'] !!}</td>
                        <td>{!! $asset['area_name'] !!}</td>
                        <td>{!! $asset['category_name'] !!}</td>
                        <td>{!! $asset['conservation_state'] !!}</td>
                    </tr>
                @endforeach
            </tbody>

        </table>

    </body>
</html>

