<?php

Route::group(['middleware' => 'web', 'prefix' => 'reports', 'namespace' => 'Modules\Reports\Http\Controllers'], function () {

    Route::get('/', 'ReportsController@index')->name('reports');

    Route::get('/pdfreport',[
        'as' => 'reports.pdfreport',
        'uses' => 'ReportsController@pdfReport',
    ]);

    Route::get('/pdfreport/{company}',[
        'as' => 'reports.pdfcompanyreport',
        'uses' => 'ReportsController@pdfReport',
    ]);

    Route::get('/pdfreport/{company_id}/{place_id}',[
        'as' => 'reports.pdfplacereport',
        'uses' => 'ReportsController@pdfReport',
    ]);

    Route::get('/conservationstate', 'ConservationStateReportController@index')->name('conservationstate.reports');

    Route::get('/conservationstate/pdfreport',[
        'as' => 'conservationstate.reports.pdfreport',
        'uses' => 'ConservationStateReportController@pdfReport',
    ]);

    Route::get('/conservationstate/pdfreport/{company}',[
        'as' => 'conservationstate.reports.pdfcompanyreport',
        'uses' => 'ConservationStateReportController@pdfReport',
    ]);

    Route::get('/conservationstate/pdfreport/{company_id}/{place_id}',[
        'as' => 'conservationstate.reports.pdfplacereport',
        'uses' => 'ConservationStateReportController@pdfReport',
    ]);

    Route::get('/costs', 'CostsReportController@index')->name('costs.reports');

    Route::get('/costs/pdfreport',[
        'as' => 'costs.reports.pdfreport',
        'uses' => 'CostsReportController@pdfReport',
    ]);

    Route::get('/costs/pdfreport/{company}',[
        'as' => 'costs.reports.pdfcompanyreport',
        'uses' => 'CostsReportController@pdfReport',
    ]);

    Route::get('/costs/pdfreport/{company_id}/{place_id}',[
        'as' => 'costs.reports.pdfplacereport',
        'uses' => 'CostsReportController@pdfReport',
    ]);
    
});
