<?php

namespace Modules\Reports\Http\Forms;


use Kris\LaravelFormBuilder\Form;

use Modules\Places\Entities\Place;
use Modules\Companies\Entities\Company;
use Modules\Platform\Core\Helper\FormHelper;


class ReportForm extends Form {

    public function buildForm() {

        if(\Auth::user()->hasRole('admin')){
            if(isset($this->model) && isset($this->model['company']) && $this->model['company'] != null ){
                $places = Place::where('company_id', $this->model['company'])->pluck('identifier_name', 'id')->toArray();
            }
            else{
                $places = [ '' => 'Relatório geral' ];
            }
        }
        elseif(\Auth::user()->hasRole('chefe')){
            $places = Place::where('company_id', \Auth::user()->company_id)->pluck('identifier_name', 'id')->toArray();
        }
        elseif(\Auth::user()->hasRole('gerente')){
            $places = Place::where('id', \Auth::user()->place_id)->pluck('identifier_name', 'id')->toArray();
        }

        if(\Auth::user()->hasRole('admin')){

            $this->add('company', 'select', [
                'label'    => trans('reports::reports.form.company'),
                'choices'  => Company::pluck('name','id')->toArray(),
                'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'company_select'],
                'expanded' => true,
                'multiple' => true,
                'empty_value' => trans('reports::reports.empty_select'),
            ]);
        }
        else{

            $this->add('company', 'hidden', [
                'value' => \Auth::user()->company_id
            ]);
        }
 
        $this->add('place', 'select', [
            'label'    => trans('reports::reports.form.place'),
            'choices'  => $places,
            'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'place_select'],
            'expanded' => true,
            'multiple' => true,
            'empty_value' => trans('reports::reports.empty_select'),
        ]);


        $this->add('submit', 'submit', [
            'label' => trans('reports::reports.form.send_report'),
            'attr'  => ['class' => 'btn btn-primary waves-effect pull-right'],
        ]);
    }

}