<?php

namespace Modules\Reports\Http\Controllers;

use PDF;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Assets\Entities\Asset;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Category;
use Modules\Asset\Service\AssetService;
use Modules\Companies\Entities\Company;
use Modules\Reports\Http\Forms\ReportForm;
use Kris\LaravelFormBuilder\FormBuilderTrait;
use Modules\Reports\Datatables\ConservationStateReportDatatable;
use Modules\Platform\Core\Datatable\Scope\OwnableEntityScope;
use Modules\Platform\Core\Http\Controllers\AppBaseController;

class ConservationStateReportController extends AppBaseController
{
    use FormBuilderTrait;

    protected $datatable = ConservationStateReportDatatable::class;

    protected $formClass = ReportForm::class;

    /**
     * Reports
     * @return \Illuminate\View\View
     */
    public function index(Request $request) {

        $data = $request->all();

        $assetService = \App::make(AssetService::class);
        $datatable = \App::make($this->datatable);

        $datatable->setTableId('RelatedModalTable');

        $dataPieChartCategory = '';

        if($request->exists('place') && $request->exists('company')){
            $request->session()->put('placeReport',$data['place']);
            $request->session()->put('companyReport',$data['company']);
        }

        if($request->exists('company') && $request->get('company') != null){

            if($request->exists('place') && $request->get('place') != ''){

                $datatable->setQueryType(ConservationStateReportDatatable::QUERY_BY_PLACE);
                $datatable->setIdQuery($request->get('place'));
                $assetsCount = $assetService->countByPlace($request->get('place'));
                $dataPieChart = $assetService->getByConservationState(null,$request->get('place'));
                $dataPieChartCategory = $assetService->getByConservationStateAndCategories(null,$request->get('place'));
                $reportLink = route('conservationstate.reports.pdfplacereport',[$request->session()->get('companyReport'),$request->session()->get('placeReport')]);
                $categories = Category::all();
            }
            else {

                $datatable->setQueryType(ConservationStateReportDatatable::QUERY_BY_COMPANY);
                $datatable->setIdQuery($request->get('company'));
                $assetsCount = $assetService->countByCompany($request->get('company'));
                $dataPieChart = $assetService->getByConservationState($request->get('company'));
                $dataPieChartCategory = $assetService->getByConservationStateAndCategories($request->get('company'));
                $reportLink = route('conservationstate.reports.pdfcompanyreport', $request->get('company'));
                $categories = Category::all();
            }
        }

        else {

            if(\Auth::user()->hasRole('admin')){

                $datatable->setQueryType(ConservationStateReportDatatable::GENERAL_QUERY);
                $assetsCount = $assetService->generalCount();
                $dataPieChart = $assetService->getByConservationState();
                $dataPieChartCategory = $assetService->getByConservationStateAndCategories();
                $reportLink = route('conservationstate.reports.pdfreport');
                $categories = Category::all();
            }
            elseif(\Auth::user()->hasRole('chefe')){

                $datatable->setQueryType(ConservationStateReportDatatable::QUERY_BY_COMPANY);
                $datatable->setIdQuery(\Auth::user()->company_id);
                $assetsCount = $assetService->countByCompany(\Auth::user()->company_id);
                $dataPieChart = $assetService->getByConservationState(\Auth::user()->company_id);
                $dataPieChartCategory = $assetService->getByConservationStateAndCategories(\Auth::user()->company_id);
                $reportLink = route('conservationstate.reports.pdfcompanyreport', \Auth::user()->company_id);
                $categories = Category::all();
            }
            elseif(\Auth::user()->hasRole('gerente')){

                $datatable->setQueryType(ConservationStateReportDatatable::QUERY_BY_PLACE);
                $datatable->setIdQuery(\Auth::user()->place_id);
                $assetsCount = $assetService->countByPlace(\Auth::user()->place_id);
                $dataPieChart = $assetService->getByConservationState(null,\Auth::user()->place_id);
                $dataPieChartCategory = $assetService->getByConservationStateAndCategories(null,\Auth::user()->place_id);
                $reportLink = route('conservationstate.reports.pdfplacereport',[\Auth::user()->company_id, \Auth::user()->place_id]);
                $categories = Category::all();
            }

        }

        if(isset($data['draw'])){

            if($request->session()->exists('companyReport') && $request->session()->get('companyReport') != ''){

                if($request->session()->exists('placeReport') && $request->session()->get('placeReport') != ''){

                    $datatable->setQueryType(ConservationStateReportDatatable::QUERY_BY_PLACE);
                    $datatable->setIdQuery($request->session()->get('placeReport'));
                    $assetsCount = $assetService->countByPlace($request->session()->get('placeReport'));
                    $dataPieChart = $assetService->getByConservationState(null,$request->session()->get('placeReport'));
                    $dataPieChartCategory = $assetService->getByConservationStateAndCategories(null,$request->session()->get('placeReport'));
                    $reportLink = route('conservationstate.reports.pdfplacereport',[$request->session()->get('companyReport'),$request->session()->get('placeReport')]);
                    $categories = Category::all();
                }
                else {

                    $datatable->setQueryType(ConservationStateReportDatatable::QUERY_BY_COMPANY);
                    $datatable->setIdQuery($request->session()->get('companyReport'));
                    $assetsCount = $assetService->countByCompany($request->session()->get('companyReport'));
                    $dataPieChart = $assetService->getByConservationState($request->session()->get('companyReport'));
                    $dataPieChartCategory = $assetService->getByConservationStateAndCategories($request->session()->get('companyReport'));
                    $reportLink = route('conservationstate.reports.pdfcompanyreport', $request->session()->get('companyReport'));
                    $categories = Category::all();
                }
            }
            else{

                if(\Auth::user()->hasRole('admin')){

                    $datatable->setQueryType(ConservationStateReportDatatable::GENERAL_QUERY);
                    $assetsCount = $assetService->generalCount();
                    $dataPieChart = $assetService->getByConservationState();
                    $dataPieChartCategory = $assetService->getByConservationStateAndCategories();
                    $reportLink = route('conservationstate.reports.pdfreport');
                    $categories = Category::all();
                }
                elseif(\Auth::user()->hasRole('chefe')){

                    $datatable->setQueryType(ConservationStateReportDatatable::QUERY_BY_COMPANY);
                    $datatable->setIdQuery(\Auth::user()->company_id);
                    $assetsCount = $assetService->countByCompany(\Auth::user()->company_id);
                    $dataPieChart = $assetService->getByConservationState(\Auth::user()->company_id);
                    $dataPieChartCategory = $assetService->getByConservationStateAndCategories(\Auth::user()->company_id);
                    $reportLink = route('conservationstate.reports.pdfcompanyreport', \Auth::user()->company_id);
                    $categories = Category::all();
                }
                elseif(\Auth::user()->hasRole('gerente')){

                    $datatable->setQueryType(ConservationStateReportDatatable::QUERY_BY_PLACE);
                    $datatable->setIdQuery(\Auth::user()->place_id);
                    $assetsCount = $assetService->countByPlace(\Auth::user()->place_id);
                    $dataPieChart = $assetService->getByConservationState(null,\Auth::user()->place_id);
                    $dataPieChartCategory = $assetService->getByConservationStateAndCategories(null,\Auth::user()->place_id);
                    $categories = Category::all();
                    $reportLink = route('conservationstate.reports.pdfplacereport',[\Auth::user()->company_id, \Auth::user()->place_id]);
                }
            }

            $request->session()->forget('placeReport');
            $request->session()->forget('companyReport');

        }

        $form = $this->form($this->formClass, [
            'method' => 'GET',
            'url' => '/reports/conservationstate',
            'id' => 'module_form',
            'model' => $data
        ]);

        $datatable->setAjaxSource(route('conservationstate.reports'));
        $datatable->addScope(new OwnableEntityScope(\Auth::user(), 'reports'));

        \JavaScript::put([
            'dataPieChart' => json_encode($dataPieChart),
            'categories' => json_encode($categories),
            'dataPieChartCategory' => json_encode($dataPieChartCategory)
        ]);

        return $datatable = $datatable->render('reports::conservation_state', 
            compact(
                'assetsCount',
                'dataPieChart',
                'dataContainerChart',
                'form',
                'reportLink',
                'categories',
                'dataPieChartCategory'
            )
        );

    }

    public function pdfReport($company_id = null,$place_id = null){

        $asset = new Asset();

        $assets = $asset->newQuery()
        ->leftJoin('categories', 'assets.category_id', '=', 'categories.id')
        ->leftJoin('areas', 'assets.area_id', '=', 'areas.id')
        ->select([
            'assets.id',
            'assets.asset_number',
            'assets.category_id',
            'assets.conservation_state',
            'assets.area_id',
            'areas.name as area_name',
            'categories.name as category_name',
        ]);
        if($place_id != null){
            $assets = $assets->where('assets.place_id', $place_id);
        }
        elseif($company_id != null){
            $assets = $assets->where('assets.company_id', $company_id);
        }
        $assets = $assets->get();

        if($place_id != null){
            $place = Place::find($place_id);
            $fileName = trans('reports::reports.asset_conservation_state_report') . $place->identifier_name . '.pdf';
            $view = view('reports::reports.pdfReportConservationState', [
                'assets' => $assets,
                'place' => $place
            ]);
        }
        elseif($company_id != null){
            $company = Company::find($company_id);
            $fileName = trans('reports::reports.asset_conservation_state_report') . $company->name . '.pdf';
            $view = view('reports::reports.pdfReportConservationState', [
                'assets' => $assets,
                'company' => $company
            ]);
        }
        else{
            $fileName = trans('reports::reports.asset_conservation_state_report') . '.pdf';
            $view = view('reports::reports.pdfReportConservationState', [
                'assets' => $assets
            ]);
        }

        $pdf = PDF::loadHTML($view);

        return $pdf->download($fileName);

    }


}
