<?php

namespace Modules\Platform\User\Service;

use Modules\Platform\User\Entities\User;

/**
 * Class UserService
 * @package Modules\Platform\User\Service
 */
class UserService
{
    /**
     * Count of users according to access rules
     *
     * @return integer
     */
    public function count() {

        if(\Auth::user()->hasRole('admin')){

            return User::count();
        }

        elseif(\Auth::user()->hasRole('chefe')){

            return User::where('company_id',\Auth::user()->company_id)->count();
        }

        elseif(\Auth::user()->hasRole('gerente')){

            return User::where('place_id',\Auth::user()->place_id)->count();
        }

    }

    /**
     * Count of users according to some company
     *
     * @return integer
     */
    public function countByCompany($company_id) {

        return User::where('company_id',$company_id)->count();

    }


    /**
     * Count of users according to some place
     *
     * @return integer
     */
    public function countByPlace($place_id) {

        return User::where('place_id',$place_id)->count();

    }

    /**
     * return users for notify
     *
     * @return array
     */
    public function getUsersForNotify($company_id) {

        $usersForNotify = [];

        foreach(User::all() as $user){

            if(($user->hasRole('admin') || ( $user->hasRole('chefe') && $user['company_id'] == $company_id )) && $user['id'] != \Auth::user()->id ) {

                $usersForNotify[] = $user;
            }

        }

        return $usersForNotify;
    }


}
