<?php

namespace Modules\Platform\User\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Platform\Core\Helper\FileHelper;
use Modules\Platform\Core\Helper\ThemeHelper;
use Modules\Platform\Core\Helper\UserHelper;
use Modules\Platform\Settings\Entities\Language;
use Modules\Platform\User\Entities\DateFormat;
use Modules\Platform\User\Entities\TimeFormat;
use Modules\Platform\User\Entities\TimeZone;
use Spatie\Permission\Models\Role;
use Modules\Companies\Entities\Company;
use Modules\Places\Entities\Place;

/**
 * Class UserForm
 * @package Modules\Platform\User\Http\Forms
 */
class UserForm extends Form
{
    public function buildForm()
    {
        $this->add('email', 'email', [
            'label' => trans('user::users.form.email'),
        ]);

        if (isset($this->model['relatedEntity']) && isset($this->model['place_id'])) {
            $this->model['company_id'] = Place::find($this->model['place_id'])['company_id'];
        }

        /**
         * Request for modal create entity
         */
        // if(isset($this->model['relatedEntity']) && isset($this->model['company_id']) && $this->model['company_id'] != null){

        //     $this->add('company_id', 'choice', [
        //         'choices' => Company::all()->pluck('name', 'id')->toArray(),
        //         'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
        //         'selected' => $this->model['company_id'],
        //         'expanded' => false,
        //         'empty_value' => trans('core::core.empty_select'),
        //         'label' => trans('assets::assets.form.company'),
        //     ]);

        //     $this->add('company', 'hidden', [
        //         'attr' => ['name' => 'company_id' ],
        //         'value' => $this->model['company_id']
        //     ]);
        // }
        // elseif(isset($this->model['relatedEntity']) && isset($this->model['place_id']) && $this->model['place_id'] != null && \Auth::user()->hasRole('admin')){

        //     $this->add('company_id', 'choice', [
        //         'choices' => Company::all()->pluck('name', 'id')->toArray(),
        //         'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
        //         'selected' => Place::find($this->model['place_id'])->company_id,
        //         'expanded' => false,
        //         'empty_value' => trans('core::core.empty_select'),
        //         'label' => trans('assets::assets.form.company'),
        //     ]);

        //     $this->add('company', 'hidden', [
        //         'attr' => ['name' => 'company_id' ],
        //         'value' => Place::find($this->model['place_id'])->company_id
        //     ]);
        // }

        // elseif(\Auth::user()->hasRole('admin')){

        //     $this->add('company_id', 'choice', [
        //         'choices' => Company::all()->pluck('name', 'id')->toArray(),
        //         'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'company_select'],
        //         'expanded' => false,
        //         'empty_value' => trans('core::core.empty_select'),
        //         'label' => trans('assets::assets.form.company'),
        //     ]);
        // }
        // else{

        //     $this->add('company_id', 'hidden', [
        //         'attr' => ['name' => 'company_id' ],
        //         'value' => \Auth::user()->company_id
        //     ]);
        // }

        // if(! \Auth::user()->hasRole('gerente')){

        //     /**
        //      * Request for modal create entity
        //      */
        //     if(isset($this->model['relatedEntity']) && isset($this->model['place_id']) && $this->model['place_id'] != null){

        //         $this->add('place_id', 'choice', [
        //             'choices' => Place::all()->pluck('identifier_name', 'id')->toArray(),
        //             'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
        //             'selected' => $this->model['place_id'],
        //             'expanded' => false,
        //             'empty_value' => trans('core::core.empty_select'),
        //             'label' => trans('assets::assets.form.place'),
        //         ]);
        //         $this->add('place', 'hidden', [
        //             'attr' => ['name' => 'place_id' ],
        //             'value' => $this->model['place_id']
        //         ]);
        //     }
        //     else{
        //         $places = [];
        //         if(isset($this->model['company_id']) && $this->model['company_id'] != null){
        //             $places = Place::where('company_id', $this->model['company_id'])->pluck('identifier_name', 'id')->toArray();
        //         }
        //         elseif( \Auth::user()->hasRole('admin')){
        //             $places = [];
        //         }
        //         else{
        //             $places = Place::where('company_id', \Auth::user()->company_id)->pluck('identifier_name', 'id')->toArray();
        //         }

        //         $this->add('place_id', 'choice', [
        //             'choices' => $places,
        //             'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'place_select'],
        //             'selected' => isset($this->model->place_id) ? $this->model->place_id : '' ,
        //             'expanded' => false,
        //             'empty_value' => trans('core::core.empty_select'),
        //             'label' => trans('assets::assets.form.place'),
        //         ]);
        //     }
        // }
        // else{
        //     $this->add('place_id', 'hidden', [
        //         'attr' => ['name' => 'place_id' ],
        //         'value' => \Auth::user()->place_id
        //     ]);
        // }

        if(\Auth::user()->hasRole('admin')){

            $this->add('company_id', 'select', [
                'choices' => Company::all()->pluck('name', 'id')->toArray(),
                'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'company_select'],
                'selected' => $this->model ? $this->model->company_id : '' ,
                'expanded' => false,
                'empty_value' => trans('core::core.empty_select'),
                'label' => trans('user::users.form.company'),
            ]);

            $this->add('access_to_all_entity', 'hidden', [ ]);
        }
        else{
            $this->add('company_id', 'hidden', [
                'attr' => ['name' => 'company_id' ],
                'value' => \Auth::user()->company_id
            ]);            
        }

        $places = [];
        if(! \Auth::user()->hasRole('admin')){
            $places = Place::where('company_id', \Auth::user()->company_id)->pluck('identifier_name', 'id')->toArray();
        }
        else{
            $places = [];
        }

        $this->add('place_id', 'select', [
            'choices' => $places,
            'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'place_select'],
            'selected' => $this->model ? $this->model->place_id : '' ,
            'expanded' => false,
            'empty_value' => trans('core::core.empty_select'),
            'label' => trans('user::users.form.place'),
        ]);


        $roles = Role::all()->pluck('display_name', 'name')->toArray();
        if(! \Auth::user()->hasRole('admin')){
            unset($roles['admin']);
        }

        $this->add('roles', 'choice', [
            'choices' => $roles,
            'attr' => ['class' => 'select2 pmd-select2 form-control'],
            'selected' => $this->model ? $this->model->roles()->pluck('name')->toArray() : null ,
            'expanded' => false,
            'multiple' => true,
            'label' => trans('user::users.form.roles'),
        ]);

        $this->add('last_name', 'text', [
            'label' => trans('user::users.form.last_name'),
        ]);

        $this->add('first_name', 'text', [
            'label' => trans('user::users.form.first_name'),
        ]);

        $this->add('person_tax_number', 'text', [
            'attr' => ['class' => 'form-control cpf'],
            'label' => trans('user::users.form.person_tax_number'),
        ]);

        $this->add('birthday', 'date', [
            'label' => trans('user::users.form.birthday'),
        ]);

        $this->add('number', 'text', [
            'label' => trans('user::users.form.number'),
        ]);

        $this->add('neighborhood', 'text', [
            'label' => trans('user::users.form.neighborhood'),
        ]);

        $this->add('complement', 'text', [
            'label' => trans('user::users.form.complement'),
        ]);
        
        $this->add('is_active', 'switch', [
            'label' => trans('user::users.form.is_active'),
            'color' => 'switch-col-red'
        ]);
        
        // $this->add('title', 'text', [
        //     'label' => trans('user::users.form.title'),
        // ]);
        
        // $this->add('department', 'text', [
        //     'label' => trans('user::users.form.department'),
        // ]);
        
        // $this->add('office_phone', 'text', [
        //     'attr' => ['class' => 'form-control phone'],
        //     'label' => trans('user::users.form.office_phone'),
        // ]);
        
        $this->add('mobile_phone', 'text', [
            'attr' => ['class' => 'form-control mobile'],
            'label' => trans('user::users.form.mobile_phone'),
        ]);
        
        $this->add('home_phone', 'text', [
            'attr' => ['class' => 'form-control phone'],
            'label' => trans('user::users.form.home_phone'),
        ]);
        
        
        // $this->add('secondary_email', 'text', [
        //     'label' => trans('user::users.form.secondary_email'),
        // ]);
        
        // $this->add('theme', 'select', [
        //     'choices' => ThemeHelper::SUPPORTED_THEMES,
        //     'attr' => ['class' => 'select2 pmd-select2 form-control'],
        //     'label' => trans('user::users.form.theme'),
        //     'empty_value' => trans('core::core.empty_select')
        // ]);
     
        $this->add('address_state', 'text', [
            'label' => trans('user::users.form.address_state'),
        ]);
        
        $this->add('address_city', 'text', [
            'label' => trans('user::users.form.address_city'),
        ]);
        
        $this->add('address_postal_code', 'text', [
            'attr' => ['class' => 'form-control cep'],
            'label' => trans('user::users.form.address_postal_code'),
        ]);

        $this->add('address_street', 'text', [
            'label' => trans('user::users.form.address_street'),
        ]);

        $this->add('notes', 'textarea', [
            'label' => trans('collaborators::collaborators.form.notes'),
        ]);

        $this->add('time_format_id', 'select', [
            'choices' => TimeFormat::all()->pluck('name', 'id')->toArray(),
            'attr' => ['class' => 'select2 pmd-select2 form-control'],
            'label' => trans('user::users.form.time_format_id'),
            'empty_value' => trans('core::core.empty_select')
        ]);

        // $this->add('date_format_id', 'select', [
        //     'choices' => DateFormat::all()->pluck('name', 'id')->toArray(),
        //     'attr' => ['class' => 'select2 pmd-select2 form-control'],
        //     'label' => trans('user::users.form.date_format_id'),
        //     'empty_value' => trans('core::core.empty_select')
        // ]);

        // $this->add('time_zone', 'select', [
        //     'choices' => TimeZone::all()->pluck('name', 'php_timezone')->toArray(),
        //     'attr' => ['class' => 'select2 pmd-select2 form-control'],
        //     'label' => trans('user::users.form.time_zone'),
        //     'empty_value' => trans('core::core.empty_select')
        // ]);

        $this->add('language_id', 'select', [
            'choices' => Language::all()->pluck('name', 'id')->toArray(),
            'attr' => ['class' => 'select2 pmd-select2 form-control'],
            'label' => trans('user::users.form.language_id'),
            'empty_value' => trans('core::core.empty_select')
        ]);

        $this->add('profile_pic_conf', 'select', [
            'choices' => [
                UserHelper::PROFILE_PICTURE_INITIALS => trans('user::users.initials'),
                UserHelper::PROFILE_PICTURE_GRAVATAR => trans('user::users.gravatar'),
                UserHelper::PROFILE_PICTURE_OWN => trans('user::users.image'),
            ],
            'attr' => ['class' => 'select2 pmd-select2 form-control'],
            'label' => trans('user::users.form.profile_pic_conf'),

        ]);

        $this->add('profile_picture', 'file', [
            'label_show'=>false,
            'attr'=> ['id'=>'profile_picture'],
            'label' => trans('user::users.form.profile_picture'),
        ]);

        $this->add('submit', 'submit', [
            'label' => trans('user::users.form.save'),
            'attr' => ['class' => 'btn btn-primary m-t-15 waves-effect']
        ]);
    }
}
