@extends('layouts.app')

@section('content')


<div class="m-grid__item m-grid__item--fluid m-wrapper">
    <div class="m-subheader" style="margin:0 30px 0 30px">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="m-subheader__title ">@lang('notifications::notifications.module_description')</h3>			
            </div>
        </div>
    </div>
    <div class="m-content">

        @if($userNotifications->count() == 0)
            <div class="row m-portlet">
                <div class="m-portlet__body">
                    <h5 class="text-center">
                        @lang('notifications::notifications.no_new_notifications')
                    </h5>
                    <p class="text-center big-icon col-blue-grey">
                        <i class="material-icons big-icon">
                            @lang('notifications::notifications.notifications_none')
                        </i>
                    </p>
                </div>
            </div>
        @endif
        @if($userNotifications->count() > 0)
            <div class="m-portlet m-portlet--full-height" style="margin:0 20px 0 20px">
                <div class="m-portlet__body">
                    @foreach($userNotifications as $notification)
                        @if(isset($notification->data['content']))
                            <div class="col-xl-12">
                                <a title="@lang('notifications::notifications.delete_notification')" data-id="{{$notification->id}}" class="btn btn-brand m-btn m-btn--icon m-btn--icon-only m-btn--custom m-btn--pill pull-right delete-notification">
                                    <i class="fa fa-trash" style="color: white"></i>
                                </a>
                                <a href="{{ $notification->data['url'] != '' ? $notification->data['url'] : '#' }}">

                                    <h5>{{ $notification->data['content'] }}</h5> 
                                    <p>
                                        <i class="material-icons">@lang('notifications::notifications.date') </i> {{ \Modules\Platform\Core\Helper\UserHelper::formatUserDateTime($notification->created_at) }}
                                    </p>
                                    @if(isset($notification->data['more_content']))
                                        <p>{{$notification->data['more_content']}}</p>
                                    @endif
                                </a>
                                <hr>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        @endif
        <div class="notifications-pagination" style="margin:20px 30px 0 30px">
            {{ $userNotifications->links() }}
        </div>

    </div>
</div>

@endsection
