<?php

return [
    'setup' => [

        /**
         * Module Name
         */
        'module_name' => 'Maintenances',

        /**
         * Singular module Name
         */
        'singular_name' => 'Maintenance',

        /**
         * If set to true. Visibility of records in module will be limited with "Assigned TO" field (User or Group)
         */
        'entity_private_access' => false,

        /**
         * Entities definition
         */
        'entity' => [
            'maintenance' => [

                /**
                 * Entity name
                 */
                'name' => 'Maintenance',

                /**
                 * Entity database table name
                 */
                'table' => 'maintenances',

                /**
                 * main - Main entity of module.
                 * settings - Dictionary entity of module
                 */
                'type' => 'main',

                /**
                 * HasMorphOwner trait will be added to entity
                 */
                'ownable' => false,

                /**
                 * LogsActivity trait will be added to entity
                 */
                'activity' => false,

                /**
                 * Commentable trait will be added to entity
                 */
                'comments' => false,

                /**
                 * HasAttachment trait will be added to entity
                 */
                'attachments' => false,

                'properties' => [

                    /**
                     * Definition of section in show|create|edit
                     */
                    'information' => [

                        /**
                         * Entity field (key is a name of field)
                         * type - type of entity.
                         * supported types:
                         * - string    - text filed (Normal input)
                         * - integer   - Integer field (Number field)
                         * - text      - Textarea field
                         * - ownedBy   - Required if use ownable trait (Dropdown)
                         * - manyToOne - Dictionary    (Dropdown)
                         * - date      - Date field    (Calendar)
                         * - email     - text field    (Text with validation)
                         * - decimal   - Decimal field (Number field)
                         * - datetime  - Date with time (calendar with time)
                         * - boolean   - Checkbox
                         *
                         * rules - rules generated in request object
                         */
                        'maintenance_company' => [
                            'type' => 'string',
                        ],
                        'company_id' => [
                            'type' => 'manyToOne', 
                            'relation' => 'Company',
                            'column' => 'name',
                            'belongs_to' => 'Company',
                            'display_column' => 'name',
                        ],
                        'place_id' => [
                            'type' => 'manyToOne', 
                            'relation' => 'Place',
                            'column' => 'identifier_name',
                            'belongs_to' => 'Place',
                            'display_column' => 'identifier_name',
                        ],
                        'asset_id' => [
                            'type' => 'manyToOne', 
                            'relation' => 'Asset',
                            'column' => 'item',
                            'belongs_to' => 'Asset',
                            'display_column' => 'item',
                        ],
                        'maintenance_date' => [
                            'type' => 'date',
                        ],
                        'value' => [
                            'type' => 'decimal',
                        ], 
                    ],
                    // 'address_information' => [
                    //     'street' => ['type' => 'string'],
                    //     'city' => ['type' => 'string'],
                    //     'state' => ['type' => 'string'],
                    //     'country' => ['type' => 'string'],
                    //     'zip_code' => ['type' => 'string'],
                    // ],
                    'notes' => [
                        'notes' => ['type' => 'text'],
                    ]
                ]
            ],

            // 'maintenance_type' => [
            //     'name' => 'MaintenanceType',
            //     'table' => 'companies_dict_type',
            //     'type' => 'settings',

            //     'insert_data' => [
            //         'small_maintenance',
            //         'medium_maintenance',
            //         'big_maintenance'
            //     ],
            //     'properties' => [
            //         'detail' => [
            //             'name' => [
            //                 'type' => 'string',
            //             ],
            //         ],
            //     ]
            // ],

            // 'maintenance_industry' => [
            //     'name' => 'MaintenanceIndustry',
            //     'table' => 'companies_dict_industry',
            //     'type' => 'settings',

            //     'insert_data' => [
            //         'communications',
            //         'technology',
            //         'manufacturing'
            //     ],
            //     'properties' => [
            //         'detail' => [
            //             'name' => [
            //                 'type' => 'string',
            //             ],
            //         ],
            //     ]
            // ],

            // 'maintenance_rating' => [
            //     'name' => 'MaintenanceRating',
            //     'table' => 'companies_dict_rating',
            //     'type' => 'settings',

            //     'insert_data' => [
            //         'acquired',
            //         'active',
            //         'market_failed',
            //         'project_cancelled',
            //         'shut_down'
            //     ],
            //     'properties' => [
            //         'detail' => [
            //             'name' => [
            //                 'type' => 'string',
            //             ],
            //         ],
            //     ]
            // ],


        ]

    ]
];