<?php

Route::group(['middleware' => ['web','permission:clients.browse'],'prefix'=>'places', 'as'=>'places.', 'namespace' => 'Modules\Places\Http\Controllers'], function()
{
    Route::get('/',function(){
        return redirect()->route('places.places.index');
     });

     Route::group(['middleware' => ['web','permission:places.settings']], function(){ });
     
    // Collaborators Routes
    Route::get('places/collaborators-selection/{entityId}', ['as'=>'collaborators.selection','uses'=> 'Tabs\PlaceCollaboratorsController@selection']);
    Route::get('places/collaborators-linked/{entityId}', ['as'=>'collaborators.linked','uses'=> 'Tabs\PlaceCollaboratorsController@linked']);
    Route::post('places/collaborators-unlink', ['as'=>'collaborators.unlink','uses'=> 'Tabs\PlaceCollaboratorsController@unlink']);
    Route::post('places/collaborators-link', ['as'=>'collaborators.link','uses'=> 'Tabs\PlaceCollaboratorsController@link']);

    // Assets Routes
    Route::get('places/assets-selection/{entityId}', ['as'=>'assets.selection','uses'=> 'Tabs\PlaceAssetsController@selection']);
    Route::get('places/assets-linked/{entityId}', ['as'=>'assets.linked','uses'=> 'Tabs\PlaceAssetsController@linked']);
    Route::post('places/assets-unlink', ['as'=>'assets.unlink','uses'=> 'Tabs\PlaceAssetsController@unlink']);
    Route::post('places/assets-link', ['as'=>'assets.link','uses'=> 'Tabs\PlaceAssetsController@link']);

    // Users Routes
    Route::get('places/users-selection/{entityId}', ['as'=>'users.selection','uses'=> 'Tabs\PlaceUsersController@selection']);
    Route::get('places/users-linked/{entityId}', ['as'=>'users.linked','uses'=> 'Tabs\PlaceUsersController@linked']);
    Route::post('places/users-unlink', ['as'=>'users.unlink','uses'=> 'Tabs\PlaceUsersController@unlink']);
    Route::post('places/users-link', ['as'=>'users.link','uses'=> 'Tabs\PlaceUsersController@link']);


    Route::resource('places', 'PlacesController');
});
