<?php

namespace Modules\Places\Http\Requests;

use App\Http\Requests\Request;

/**
 * Class PlacesRequest
 * @package Modules\Places\Http\Requests
 */
class PlacesRequest extends Request
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $company_id = $this->request->get('company_id');

        return [
            'identifier_name' => 'required|unique:places,identifier_name,NULL,id,company_id,' . $company_id ,
            'company_id' => 'required' ,
        ];
    }

    public function attributes() {
        return [
            'identifier_name' => trans('companies::companies.form.name'),
            'company_id' => trans('companies::companies.module'),

        ];
    }

}