<?php

namespace Modules\Places\Http\Controllers\Tabs;

use Modules\Places\Entities\Place;
use Modules\Collaborators\Entities\Collaborator;
use Modules\Platform\Core\Datatable\Scope\BasicRelationScope;
use Modules\Platform\Core\Http\Controllers\ModuleCrudRelationController;
use Modules\Places\Datatables\Tabs\PlaceCollaboratorsDatatable;

/**
 * Class AccountsTicketsController
 * @package Modules\Collaborators\Http\Controllers
 */
class PlaceCollaboratorsController extends ModuleCrudRelationController
{
    protected $datatable = PlaceCollaboratorsDatatable::class;

    protected $ownerModel = Place::class;

    protected $relationModel = Collaborator::class;

    protected $ownerModuleName = 'places';

    protected $relatedModuleName = 'collaborators';

    protected $scopeLinked = BasicRelationScope::class;

    protected $modelRelationName = 'collaborators';

    protected $relationTableName = 'collaborators';

    protected $relationType = self::RT_ONE_TO_MANY;

    protected $belongsToName = 'Place';
}
