<?php

namespace Modules\Places\Entities;

use Carbon\Carbon;
use Modules\Assets\Entities\Asset;
use Cog\Contracts\Ownership\Ownable;
use Illuminate\Database\Eloquent\Model;
use Modules\Platform\User\Entities\User;
use Modules\Suppliers\Entities\Supplier;
use Bnb\Laravel\Attachments\HasAttachment;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Platform\Core\Traits\Commentable;
use Cog\Laravel\Ownership\Traits\HasMorphOwner;
use Modules\Collaborators\Entities\Collaborator;
use Modules\Platform\Core\Helper\ActivityLogHelper;

class Place extends Model 
{

    use SoftDeletes;

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [

    ];
    public $table = 'places';

    public $fillable = [
        'identifier_name',
        'city',
        'state',
        'street',
        'number',
        'neighborhood',
        'complement',
        'postal_code',
        'notes',
        'company_id',
    ];

    protected $dates = ['deleted_at', 'created_at', 'updated_at'];   

    public function collaborators()
    {
        return $this->hasMany(Collaborator::class);
    }

    public function assets()
    {
        return $this->hasMany(Asset::class);
    }
    
    public function users()
    {
        return $this->hasMany(User::class);
    }


}
