<?php

namespace Modules\Maintenances\Entities;

use Bnb\Laravel\Attachments\HasAttachment;
use Cog\Contracts\Ownership\Ownable;
use Cog\Laravel\Ownership\Traits\HasMorphOwner;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Platform\Core\Helper\ActivityLogHelper;
use Modules\Platform\Core\Traits\Commentable;
use Spatie\Activitylog\Traits\LogsActivity;
use Modules\Companies\Entities\Company;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Asset;
use Carbon\Carbon;

/**
 * @property int $id
 * @property int $company_id
 * @property int $place_id
 * @property int $asset_id
 * @property int $value
 * @property int $maintenance_date
 * @property int $maintenance_company
 * @property int $notes

 */
class Maintenance extends Model 
{

    use SoftDeletes;

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [

    ];
    public $table = 'maintenances';

    public $fillable = [
        'maintenance_company',
        'company_id',
        'place_id',
        'asset_id',
        'maintenance_date',
        'value',
        'notes',
    ];


    protected $dates = ['deleted_at', 'created_at', 'updated_at'];

    /**
            * Required to proper parse date provided in user date format
            * @param  $value
            */
    public function setmaintenanceDateAttribute($value)
    {
        $parsed = Carbon::createFromFormat('d/m/Y', $value);

        $this->attributes['maintenance_date'] = $parsed;
    }


    /**
            * @return  \Illuminate\Database\Eloquent\Relations\BelongsTo
            */
    public function Company()
    {
        return $this->belongsTo(Company::class);
    }


    /**
    * @return  \Illuminate\Database\Eloquent\Relations\BelongsTo
    */
    public function Place()
    {
        return $this->belongsTo(Place::class);
    }


    /**
    * @return  \Illuminate\Database\Eloquent\Relations\BelongsTo
    */
    public function Asset()
    {
        return $this->belongsTo(Asset::class);
    }

}
