<?php

namespace Modules\Maintenances\Datatables;


use Modules\Maintenances\Entities\Maintenance;
use Modules\Platform\Core\Datatable\PlatformDataTable;
use Modules\Platform\Core\Helper\DataTableHelper;
use Yajra\DataTables\EloquentDataTable;
use Carbon\Carbon;

class MaintenanceDatatable extends PlatformDataTable
{

    const SHOW_URL_ROUTE = 'maintenances.maintenances.show';
    const EDIT_URL_ROUTE = 'maintenances.maintenances.edit';
    const REMOVE_URL_ROUTE = 'maintenances.maintenances.destroy';

    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        
        $this->applyLinks($dataTable, self::SHOW_URL_ROUTE, self::EDIT_URL_ROUTE, self::REMOVE_URL_ROUTE);

        $dataTable->filterColumn('maintenance_date', function ($query, $keyword) {

            $dates = DataTableHelper::getDatesForFilter($keyword);

            if ($dates != null) {
                $query->whereBetween('maintenance_date', array($dates[0], $dates[1]));
            }
        });

        return $dataTable;
    }

    /**
     * Get query source of dataTable.
     *
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Maintenance $model)
    {
        $query = $model->newQuery()
                 ->select([
                    'maintenances.*',
                    'assets.item',
                ])
                ->leftJoin('assets', 'maintenances.asset_id', '=', 'assets.id');
    
        if (\Auth::user()->hasRole('chefe')) {
            $query = $query->where('assets.company_id',\Auth::user()->company_id);
        }
        else if(\Auth::user()->hasRole('gerente')){
            $query = $query->where('assets.place_id',\Auth::user()->place_id);
        }
        
        return $query;
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        //TODO Implement multiselect

        return $this->builder()
            ->columns($this->getColumns())

            ->setTableAttribute('class', 'table responsive table-hover')
            ->parameters([
                'dom' => "<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",

                'stateSave' => true,
                'columnFilters' => [
                    [
                        'column_number' => 0,
                        'filter_type' => 'text'
                    ],
                    [
                        'column_number' => 1,
                        'filter_type' => 'bap_date_range_picker',

                    ],
                    [
                        'column_number' => 2,
                        'filter_type' => 'text'
                    ],
                ],
                'buttons' => DataTableHelper::buttons(),
                'regexp' => true

            ]);
    }

    /**
     * @return array
     */
    protected function getColumns()
    {
        return
            [
                'item' => [
                    'data' => 'item',
                    'name' => 'assets.item',
                    'title' => trans('maintenances::maintenances.table.item'),
                    'data_type' => 'text'
                ],
                'maintenance_date' => [
                    'data' => 'maintenance_date',
                    'title' => trans('maintenances::maintenances.table.maintenance_date'),
                    'data_type' => 'date'
                ],
                'value' => [
                    'data' => 'value',
                    'title' => trans('maintenances::maintenances.table.value'),
                    'data_type' => 'text'
                ],
                'actions' => ['title' => trans('core::core.table.actions'), 'data_type' => 'actions', 'orderable' => false],
            ];

    }

}
