<div class="m-portlet m-portlet--full-height m-portlet--rounded">
    <div class="m-portlet__head">
        <div class="m-portlet__head-caption">
            <div class="m-portlet__head-title">
                <h3 class="m-portlet__head-text">
                    @lang('dashboard::dashboard.last_updates.last_updates')
                </h3>
            </div>
        </div>
    </div>
    <div class="m-portlet__body">
        <div class="m-scrollable" data-scrollable="true" data-scrollbar-shown="true"  data-height="400" style="overflow:hidden; height: 400px">
            <div class="m-timeline-3">
                <div class="m-timeline-3__items">
                    @if(count($lastUpdates) == 0)
                        <span> @lang('dashboard::dashboard.last_updates.no_updates')  </span>
                    @else
                        @foreach($lastUpdates as $update)
                            <div class="m-widget2">
                                <div class="m-widget2__item m-widget2__item--primary">
                                    <div class="m-widget2__checkbox">
                                    </div>
                                    <div class="m-widget2__desc">
                                        <b>@lang('dashboard::dashboard.last_updates.asset') {!! $update->changes()['attributes']['asset_number'] !!} @lang('dashboard::dashboard.last_updates.'.$update->description )</b> <br>
                                        @foreach($update->changes() as $field => $value)
                                            @if($update->description == 'updated')

                                                @foreach($value as $key => $v)
                                                    @if($update->changes()['attributes'][$key] != $update->changes()['old'][$key])
                                                        <span>
                                                            @lang('dashboard::dashboard.last_updates.field') 
                                                            @lang('dashboard::dashboard.attributes.'.$key) 
                                                            @lang('dashboard::dashboard.last_updates.changed'):
                                                        </span>
                                                        <br>
                                                        <span>
                                                            @lang('dashboard::dashboard.last_updates.from') : 
                                                            @if(!is_array($update->changes()['old'][$key]))
                                                                {!! $update->changes()['old'][$key] !!}
                                                            @endif
                                                        </span>
                                                        <br>
                                                        <span>
                                                            @lang('dashboard::dashboard.last_updates.to'): 
                                                            {!! $update->changes()['attributes'][$key] !!}
                                                        </span>
                                                        <br>
                                                    @endif
                                                @endforeach
                                            @elseif($update->description != 'created')
                                                @foreach($value as $key => $v)
                                                    <span>
                                                        @lang('dashboard::dashboard.last_updates.field') 
                                                        @lang('dashboard::dashboard.attributes.'.$key) 
                                                        @lang('dashboard::dashboard.last_updates.created'):
                                                    </span>
                                                    <br>
                                                @endforeach
                                            @endif
                                            @break
                                        @endforeach
                                        <br>
                                        <span class="m-widget2__user-name">
                                            <a href="#" class="m-widget2__link">
                                                @lang('dashboard::dashboard.last_updates.by') {!! $update->user_name !!} @lang('dashboard::dashboard.last_updates.on') {!! \UserHelper::formatUserDateTime($update->updated_at) !!}
                                            </a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
