<?php

namespace Modules\Companies\Http\Forms;


use Kris\LaravelFormBuilder\Form;

use Modules\Platform\Core\Helper\FormHelper;


class CompanyForm extends Form
{
    public function buildForm()
    {

        $this->add('name', 'text', [
            'label' => trans('companies::companies.form.name'),
        ]);

        $this->add('company_tax_number', 'text', [
            'attr' => ['class' => 'form-control cnpj'],
            'label' => trans('companies::companies.form.company_tax_number'),
        ]);

        $this->add('email', 'text', [
            'label' => trans('companies::companies.form.email'),
        ]);

        $this->add('phone', 'text', [
            'attr' => ['class' => 'form-control phone'],
            'label' => trans('companies::companies.form.phone'),
        ]);

        $this->add('mobile', 'text', [
            'attr' => ['class' => 'form-control mobile'],
            'label' => trans('companies::companies.form.mobile'),
        ]);

        $this->add('state', 'text', [
            'label' => trans('companies::companies.form.state'),
        ]);

        $this->add('city', 'text', [
            'label' => trans('companies::companies.form.city'),
        ]);

        $this->add('street', 'text', [
            'label' => trans('companies::companies.form.street'),
        ]);

        $this->add('number', 'text', [
            'label' => trans('companies::companies.form.number'),
        ]);

        $this->add('neighborhood', 'text', [
            'label' => trans('companies::companies.form.neighborhood'),
        ]);

        $this->add('complement', 'text', [
            'label' => trans('companies::companies.form.complement'),
        ]);

        $this->add('postal_code', 'text', [
            'attr' => ['class' => 'form-control cep'],
            'label' => trans('companies::companies.form.postal_code'),
        ]);

        $this->add('notes', 'textarea', [
            'label' => trans('companies::companies.form.notes'),
        ]);
                
        $this->add('submit', 'submit', [
            'label' => trans('core::core.form.save'),
            'attr' => ['class' => 'btn btn-primary m-t-15 waves-effect']
        ]);

    }

}