<?php

namespace Modules\Companies\Http\Controllers\Tabs;

use Modules\Companies\Entities\Company;
use Modules\Collaborators\Entities\Collaborator;
use Modules\Platform\Core\Datatable\Scope\BasicRelationScope;
use Modules\Platform\Core\Http\Controllers\ModuleCrudRelationController;
use Modules\Companies\Datatables\Tabs\CompanyCollaboratorsDatatable;

/**
 * Class AccountsTicketsController
 * @package Modules\Collaborators\Http\Controllers
 */
class CompanyCollaboratorsController extends ModuleCrudRelationController
{
    protected $datatable = CompanyCollaboratorsDatatable::class;

    protected $ownerModel = Company::class;

    protected $relationModel = Collaborator::class;

    protected $ownerModuleName = 'companies';

    protected $relatedModuleName = 'collaborators';

    protected $scopeLinked = BasicRelationScope::class;

    protected $modelRelationName = 'collaborators';
    
    protected $relationTableName = 'collaborators';

    protected $relationType = self::RT_ONE_TO_MANY;

    protected $belongsToName = 'Company';
}
