<?php

namespace Modules\Collaborators\Http\Requests;

use App\Http\Requests\Request;

/**
 * Class CollaboratorsRequest
 * @package Modules\Collaborators\Http\Requests
 */
class CollaboratorsRequest extends Request
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $company_id = $this->request->get('company_id');
        
        return [
            'name' => 'required' ,
            'place_id' => 'required' ,
            'company_id' => 'required' ,
            'area_id' => 'required' ,
            'email' => 'required|unique:collaborators,email,NULL,id,company_id,' . $company_id ,
            'person_tax_number' => 'required|unique:collaborators,person_tax_number,NULL,id,company_id,' . $company_id ,

        ];
    }

    public function attributes() {
        return [
            'name' => trans('companies::companies.form.name'),
            'area' => trans('collaborators::collaborators.form.area'),
            'place_id' => trans('places::places.module'),
            'company_id' => trans('companies::companies.module'),
        ];
    }

}