<?php

namespace Modules\Collaborators\Http\Controllers\Settings;

use Modules\Collaborators\Datatables\Settings\AreaDatatable;
use Modules\Collaborators\Entities\Area;
use Modules\Platform\Core\Http\Controllers\ModuleCrudController;
use Modules\Platform\Core\Http\Forms\NameDictionaryForm;
use Modules\Platform\Core\Http\Requests\NameDictionaryRequest;

class AreaController extends ModuleCrudController
{

    protected $datatable = AreaDatatable::class;
    protected $formClass = NameDictionaryForm::class;
    protected $storeRequest = NameDictionaryRequest::class;
    protected $updateRequest = NameDictionaryRequest::class;
    protected $entityClass = Area::class;

    protected $moduleName = 'collaborators';

    protected $settingName = 'area';

    protected $settingsBackRoute = 'collaborators.collaborators.index';

    protected $showFields = [
        'details' => [
            'name' => ['type' => 'text'],
            'notes' => ['type' => 'text'],
        ]
    ];

    protected $languageFile = 'collaborators::collaborators.area';

    protected $routes = [
        'index' => 'collaborators.area.index',
        'create' => 'collaborators.area.create',
        'show' => 'collaborators.area.show',
        'edit' => 'collaborators.area.edit',
        'store' => 'collaborators.area.store',
        'destroy' => 'collaborators.area.destroy',
        'update' => 'collaborators.area.update'
    ];

    public function __construct()
    {
        parent::__construct();
    }

}
