<?php

namespace Modules\Collaborators\Entities;

use Carbon\Carbon;
use Cog\Contracts\Ownership\Ownable;
use Illuminate\Database\Eloquent\Model;
use Bnb\Laravel\Attachments\HasAttachment;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Platform\Core\Traits\Commentable;
use Cog\Laravel\Ownership\Traits\HasMorphOwner;
use Modules\Collaborators\Entities\Collaborator;
use Modules\Platform\Core\Helper\ActivityLogHelper;

class Area extends Model 
{

    use SoftDeletes;

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [

    ];
    public $table = 'areas';

    public $fillable = [
        'name',
        'notes',
    ];

    protected $dates = ['deleted_at', 'created_at', 'updated_at'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function collaborators()
    {
        return $this->hasMany(Collaborator::class);
    }

}
