<?php

namespace Modules\Clients\Http\Controllers;

use Modules\Clients\Datatables\ClientDatatable;
use Modules\Clients\Entities\Client;
use Modules\Clients\Http\Forms\ClientForm;
use Modules\Clients\Http\Requests\ClientsRequest;
use Modules\Platform\Core\Http\Controllers\ModuleCrudController;

class ClientsController extends ModuleCrudController
{

    protected $datatable = ClientDatatable::class;
    protected $formClass = ClientForm::class;
    protected $storeRequest = ClientsRequest::class;
    protected $updateRequest = ClientsRequest::class;
    protected $entityClass = Client::class;

    protected $moduleName = 'clients';

    protected $permissions = [
        'browse' => 'clients.browse',
        'create' => 'clients.create',
        'update' => 'clients.update',
        'destroy' => 'clients.destroy'
    ];

    protected $jsFiles = [
        'BAP_Clients.js',
    ];

    protected $moduleSettingsLinks = [];

    protected $settingsPermission = 'clients.settings';

    protected $showFields = [

        'information' => [

            'company_id' => [
                'type' => 'hidden',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'place_id' => [
                'type' => 'manyToOne', 
                'relation' => 'Place',
                'column' => 'identifier_name',
                'belongs_to' => 'Place',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'fantasy_name' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'email' => [
                'type' => 'email',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'person_type' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'person_tax_number-company_tax_number' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'phone' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'mobile' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

        ],

        'address' => [

            'city' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'state' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'street' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'number' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'neighborhood' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'complement' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
            'postal_code' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

        ],
        'notes' => [

            'notes' => [
                'type' => 'text',
                'col-class' => 'col-12'
            ],
        ],

    ];

    protected $languageFile = 'clients::clients';

    protected $routes = [
        'index' => 'clients.clients.index',
        'create' => 'clients.clients.create',
        'show' => 'clients.clients.show',
        'edit' => 'clients.clients.edit',
        'store' => 'clients.clients.store',
        'destroy' => 'clients.clients.destroy',
        'update' => 'clients.clients.update'
    ];

    public function __construct()
    {
        parent::__construct();

    }

}
