<?php

namespace Modules\Clients\Entities;

use Carbon\Carbon;
use Modules\Places\Entities\Place;
use Cog\Contracts\Ownership\Ownable;
use Illuminate\Database\Eloquent\Model;
use Bnb\Laravel\Attachments\HasAttachment;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Platform\Core\Traits\Commentable;
use Cog\Laravel\Ownership\Traits\HasMorphOwner;
use Modules\Platform\Core\Helper\ActivityLogHelper;

class Client extends Model 
{

    use SoftDeletes;

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [

    ];
    public $table = 'clients';

    public $fillable = [
        'email',
        'person_type',
        'person_tax_number',
        'company_tax_number',
        'fantasy_name',
        'responsible_name',
        'phone',
        'mobile',
        'city',
        'state',
        'street',
        'number',
        'neighborhood',
        'complement',
        'postal_code',
        'notes',
        'company_id',
        'place_id',
        'person_tax_number/company_tax_number',
    ];

    protected $dates = ['deleted_at', 'created_at', 'updated_at'];   

    public function place()
    {
        return $this->belongsTo(Place::class);
    }
    
}
