<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ClientMigrationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('clients', function (Blueprint $table) {

            $table->increments('id');

            $table->integer('company_id')->unsigned()->nullable();
            $table->foreign('company_id')->references('id')->on('companies');

            $table->integer('place_id')->unsigned()->nullable();
            $table->foreign('place_id')->references('id')->on('places');

            $table->string('email')->nullable();

            $table->string('person_type')->nullable();

            $table->string('person_tax_number-company_tax_number')->nullable();

            $table->string('fantasy_name')->nullable();

            $table->string('phone')->nullable();

            $table->string('mobile')->nullable();

            $table->string('city')->nullable();

            $table->string('state')->nullable();

            $table->string('street')->nullable();

            $table->string('number')->nullable();

            $table->string('neighborhood')->nullable();

            $table->string('complement')->nullable();

            $table->string('postal_code')->nullable();

            $table->text('notes')->nullable();

            $table->timestamps();
            $table->softDeletes();

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

        Schema::dropIfExists('clients');
    }
}
