<?php

namespace Modules\Asset\Service;

use Modules\Assets\Entities\Asset;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Status;
use Modules\Companies\Entities\Company;
use Spatie\Activitylog\Models\Activity;
use Modules\Assets\Entities\AssetStatusLog;

/**
 * Class AssetService
 * @package Modules\Asset\Service
 */
class AssetStatusLogService {

    /**
     * Generate logs from assets according to status scheduled on cron
     *
     * @return mixed
     */
    public function generateLog() {

        $assetStatusLog = new AssetStatusLog();

        foreach(Place::all() as $place){

            $company = Company::find($place['company_id']);

            if(count(Status::all()) > 0){
                foreach(Status::all() as $status){

                    $quantity = Asset::where([
                        ['status_id',$status['id']],
                        ['place_id', $place['id']]   
                    ])->count();

                    $assetStatusLog->create([
                        'place_id'   => $place['id'],
                        'status_id'  => $status['id'],
                        'quantity'   => $quantity
                    ]);

                }
            }

        }

        foreach(Company::all() as $company){

            if(count(Status::all()) > 0){
                foreach(Status::all() as $status){

                    $quantity = Asset::where([
                        ['status_id',$status['id']],
                        ['company_id', $company['id']]   
                    ])->count();

                    $assetStatusLog->create([
                        'company_id' => $company['id'],
                        'status_id'  => $status['id'],
                        'quantity'   => $quantity
                    ]);

                }
            }

        }

    }

}
