<?php

namespace Modules\Assets\Http\Forms;

use Kris\LaravelFormBuilder\Form;

use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Status;
use Modules\Assets\Entities\Category;
use Modules\Companies\Entities\Company;
use Modules\Collaborators\Entities\Area;
use Modules\Suppliers\Entities\Supplier;
use Modules\Platform\Core\Helper\FormHelper;
use Modules\Collaborators\Entities\Collaborator;

class AssetForm extends Form
{
    public function buildForm()
    {

        /**
         * Request for modal create entity
         */
        if(isset($this->model['relatedEntity']) && isset($this->model['company_id']) && $this->model['company_id'] != null){

            $this->add('company_id', 'choice', [
                'choices' => Company::all()->pluck('name', 'id')->toArray(),
                'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
                'selected' => $this->model['company_id'],
                'expanded' => false,
                'empty_value' => trans('core::core.empty_select'),
                'label' => trans('assets::assets.form.company'),
            ]);

            $this->add('company', 'hidden', [
                'attr' => ['name' => 'company_id' ],
                'value' => $this->model['company_id']
            ]);
        }
        elseif(isset($this->model['relatedEntity']) && isset($this->model['place_id']) && $this->model['place_id'] != null && \Auth::user()->hasRole('admin')){

            $this->add('company_id', 'choice', [
                'choices' => Company::all()->pluck('name', 'id')->toArray(),
                'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
                'selected' => Place::find($this->model['place_id'])->company_id,
                'expanded' => false,
                'empty_value' => trans('core::core.empty_select'),
                'label' => trans('assets::assets.form.company'),
            ]);

            $this->add('company', 'hidden', [
                'attr' => ['name' => 'company_id' ],
                'value' => Place::find($this->model['place_id'])->company_id
            ]);
        }

        elseif(\Auth::user()->hasRole('admin')){

            $this->add('company_id', 'choice', [
                'choices' => Company::all()->pluck('name', 'id')->toArray(),
                'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'company_select'],
                'expanded' => false,
                'empty_value' => trans('core::core.empty_select'),
                'label' => trans('assets::assets.form.company'),
            ]);
        }
        else{

            $this->add('company_id', 'hidden', [
                'attr' => ['name' => 'company_id' ],
                'value' => \Auth::user()->company_id
            ]);
        }

        if(! \Auth::user()->hasRole('gerente')){

            /**
             * Request for modal create entity
             */
            if(isset($this->model['relatedEntity']) && isset($this->model['place_id']) && $this->model['place_id'] != null){

                $this->add('place_id', 'choice', [
                    'choices' => Place::all()->pluck('identifier_name', 'id')->toArray(),
                    'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
                    'selected' => $this->model['place_id'],
                    'expanded' => false,
                    'empty_value' => trans('core::core.empty_select'),
                    'label' => trans('assets::assets.form.place'),
                ]);
                $this->add('place', 'hidden', [
                    'attr' => ['name' => 'place_id' ],
                    'value' => $this->model['place_id']
                ]);
            }
            else{
                $places = [];
                if(isset($this->model['company_id']) && $this->model['company_id'] != null){
                    $places = Place::where('company_id', $this->model['company_id'])->pluck('identifier_name', 'id')->toArray();
                }
                elseif( \Auth::user()->hasRole('admin')){
                    $places = [];
                }
                else{
                    $places = Place::where('company_id', \Auth::user()->company_id)->pluck('identifier_name', 'id')->toArray();
                }

                $this->add('place_id', 'choice', [
                    'choices' => $places,
                    'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'place_select'],
                    'selected' => isset($this->model->place_id) ? $this->model->place_id : '' ,
                    'expanded' => false,
                    'empty_value' => trans('core::core.empty_select'),
                    'label' => trans('assets::assets.form.place'),
                ]);
            }
        }
        else{
            $this->add('place_id', 'hidden', [
                'attr' => ['name' => 'place_id' ],
                'value' => \Auth::user()->place_id
            ]);
        }

        $this->add('area_id', 'select', [
            'choices' => Area::pluck('name', 'id')->toArray(),
            'attr' => ['class' => 'select2 pmd-select2 form-control', 'id' => 'area_select'],
            'label' => trans('assets::assets.form.area_id'),
            'empty_value' => trans('core::core.empty_select')
        ]);

        $this->add('asset_number', 'text', [
            'label' => trans('assets::assets.form.asset_number'),
        ]);

        $this->add('serial_number_1', 'text', [
            'label' => trans('assets::assets.form.serial_number_1'),
        ]);

        $this->add('serial_number_2', 'text', [
            'label' => trans('assets::assets.form.serial_number_2'),
        ]);

        $this->add('image_path', 'file', [
            'label' => trans('assets::assets.form.image_path'),
            'attr' => ['class' => 'form-control'],
        ]);

        $status = [];

        $status = Status::pluck('name', 'status.id')->toArray();

        $this->add('status_id', 'choice', [
            'choices' => $status,
            'attr' => ['class' => 'select2 form-control', 'id' => 'status_select'],
            'label' => trans('assets::assets.form.status_id'),
            'empty_value' => trans('core::core.empty_select')
        ]);

        $categories = Category::pluck('name', 'id')->toArray();;
        $categories_special_fields = Category::select('special_fields', 'id')->get()->toArray();

        foreach($categories_special_fields as $special_fields){
            $this->add('special_field_'.$special_fields['id'], 'hidden', [
                'attr' => ['id' => 'special_field_'.$special_fields['id'] ],
                'value' => $special_fields['special_fields'],
            ]);
        }

        $this->add('category_id', 'select', [
            'choices' => $categories,
            'attr' => ['class' => 'select2 pmd-select2 form-control', 'id' => 'category_select'],
            'label' => trans('assets::assets.form.category_id'),
            'empty_value' => trans('core::core.empty_select')
        ]);

        if(isset($this->model->category_id) && $this->model != null && $this->model->category_id != ''){

            $category = Category::find($this->model->category_id);
            $special_fields = explode(';;',$category->special_fields);
            $asset_category_special_fields = explode(';;',$this->model->category_special_fields);

            foreach($special_fields as $key => $special_field){

                if($special_field == ''){
                    continue;
                }

                $this->add($special_field, 'text', [
                    'attr' => [
                        'id' => 'special_field_'.str_replace(' ','',$special_field),
                        'name' => 'special_field_'.str_replace(' ','++',$special_field),
                    ],
                ]);
            }
        } 

        $this->add('item', 'text', [
            'label' => trans('assets::assets.form.item'),
        ]);

        $this->add('model', 'text', [
            'label' => trans('assets::assets.form.model'),
        ]);

        $responsibles = [];
        if(isset($this->model['company_id']) && $this->model['company_id'] != null){ 
            $responsibles = Collaborator::where('company_id', $this->model['company_id'])->pluck('name', 'id')->toArray();
        }
        elseif(isset($this->model['place_id']) && $this->model['place_id'] != null){
            $responsibles = Collaborator::where('company_id', Place::find($this->model['place_id'])['company_id'])->pluck('name', 'id')->toArray();
        }
        elseif( \Auth::user()->hasRole('admin')){
            $responsibles = Collaborator::all()->pluck('name', 'id')->toArray();
        }
        elseif( \Auth::user()->hasRole('chefe')){
            $responsibles = Collaborator::where('company_id', \Auth::user()->company_id)->pluck('name', 'id')->toArray();
        }
        else{
            $responsibles = Collaborator::where('place_id', \Auth::user()->place_id)->pluck('name', 'id')->toArray();
        }

        $this->add('responsible', 'select', [
            'choices' => $responsibles,
            'attr' => ['class' => 'select2 pmd-select2 form-control', 'id' => 'responsible_select'],
            'expanded' => false,
            'empty_value' => trans('core::core.empty_select'),
            'label' => trans('assets::assets.form.responsible'),
        ]);

        $suppliers = [];
        if(isset($this->model['company_id']) && $this->model['company_id'] != null){
            $suppliers = Supplier::where('company_id', $this->model['company_id'])->pluck('fantasy_name', 'id')->toArray();
        }
        elseif(isset($this->model['place_id']) && $this->model['place_id'] != null){
            $suppliers = Supplier::where('company_id', Place::find($this->model['place_id'])['company_id'])->pluck('fantasy_name', 'id')->toArray();
        }
        elseif( \Auth::user()->hasRole('admin')){
            $suppliers = [];
        }
        else{
            $suppliers = Supplier::where('company_id', \Auth::user()->company_id)->pluck('fantasy_name', 'id')->toArray();
        }

        $this->add('supplier_id', 'select', [
            'choices' => $suppliers,
            'attr' => ['class' => 'select2 pmd-select2 form-control', 'id' => 'supplier_select'],
            'expanded' => false,
            'empty_value' => trans('core::core.empty_select'),
            'label' => trans('assets::assets.form.supplier'),
        ]);


        $this->add('purchase_date', 'date', [
            'label' => trans('assets::assets.form.purchase_date'),
        ]);

        $this->add('purchase_value', 'text', [
            'attr' => ['class' => 'form-control money'],
            'label' => trans('assets::assets.form.purchase_value'),
        ]);

        $this->add('conservation_state', 'select', [
            'choices' => [
                'muito ruim' => 'Muito ruim',
                'ruim' => 'Ruim',
                'regular' => 'Regular',
                'bom' => 'Bom',
                'perfeito' => 'Perfeito',   
            ],
            'attr' => ['class' => 'select2 pmd-select2 form-control'],
            'expanded' => false,
            'empty_value' => trans('core::core.empty_select'),
            'label' => trans('assets::assets.form.conservation_state'),
        ]);

        $this->add('useful_life', 'text', [
            'attr' => ['class' => 'form-control float-value'],
            'label' => trans('assets::assets.form.useful_life'),
        ]);

        $this->add('notes', 'textarea', [
            'label' => trans('assets::assets.form.notes'),
        ]);

        $this->add('submit', 'submit', [
            'label' => trans('core::core.form.save'),
            'attr' => ['class' => 'btn btn-primary m-t-15 waves-effect']
        ]);

    }
}