<?php

namespace Modules\Assets\Entities;

use Modules\Assets\Entities\Asset;
use Illuminate\Database\Eloquent\Model;
use Modules\Companies\Entities\Company;

/**
 * @property int $id
 * @property string $name
 * @property string $notes
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property Asset[] $assets
 */
class Status extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'status';

    /**
     * @var array
     */
    protected $fillable = [
        'name', 
        'notes', 
        'created_at', 
        'updated_at', 
        'deleted_at'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function assets()
    {
        return $this->hasMany(Asset::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function assetsStatusLogs()
    {
        return $this->hasMany(AssetsStatusLog::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function companiesStatuses()
    {
        return $this->hasMany(CompaniesStatus::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function companies()
    {
        return $this->belongsToMany(Company::class);
    }

}
