<?php

namespace Modules\Assets\Entities;

use Modules\Assets\Entities\Asset;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property string $name
 * @property string $notes
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property Asset[] $assets
 */
class Category extends Model
{
    /**
     * @var array
     */
    protected $fillable = [
        'company_id', 
        'name', 
        'notes',
        'special_fields',
        'created_at', 
        'updated_at', 
        'deleted_at'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function assets()
    {
        return $this->hasMany(Asset::class);
    }
}
