<?php

namespace Modules\Assets\Datatables\Settings;


use Modules\Assets\Entities\Status;
use Modules\Companies\Entities\Company;
use Yajra\DataTables\EloquentDataTable;
use Modules\Platform\Core\Helper\DataTableHelper;
use Modules\Platform\Core\Datatable\PlatformDataTable;

class StatusDatatable extends PlatformDataTable
{

    const SHOW_URL_ROUTE = 'assets.status.show';

    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $this->applyLinks($dataTable, self::SHOW_URL_ROUTE);

        $dataTable->filterColumn('created_at', function ($query, $keyword) {

            $dates = DataTableHelper::getDatesForFilter($keyword);

            if ($dates != null) {
                $query->whereBetween('created_at', array($dates[0], $dates[1]));
            }
        });
        $dataTable->filterColumn('updated_at', function ($query, $keyword) {

            $dates = DataTableHelper::getDatesForFilter($keyword);

            if ($dates != null) {
                $query->whereBetween('updated_at', array($dates[0], $dates[1]));
            }
        });

        return $dataTable;
    }

    /**
     * Get query source of dataTable.
     *
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Status $model)
    {
        $query = $model->newQuery()
        ->select([
            'status.id',
            'status.name',
            'status.notes',
        ]);

        if (\Auth::user()->hasRole('chefe')) {
            $query = $query->where('company_status.company_id',\Auth::user()->company_id);
        }
        else if(\Auth::user()->hasRole('gerente')){
            return null;
        }

        return $query;
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {

        $currentColumn = 0;
        $columnFilters = [];

        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];
        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];


        return $this->builder()
            ->columns($this->getColumns())

            ->setTableAttribute('class', 'table table-hover')
            ->parameters([
                'dom' => "<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",

                'stateSave' => true,
                'columnFilters' => $columnFilters,
                'buttons' => DataTableHelper::buttons(),
                'regexp' => true

        ]);
    }

    /**
     * @return array
     */
    protected function getColumns()
    {
        $data = [];

        $data += [
            'name' => [
                'data' => 'name',
                'title' => trans('assets::assets.categories.table.name'),
                'data_type' => 'text'
            ],
            'notes' => [
                'data' => 'notes',
                'title' => trans('assets::assets.categories.table.notes'),
                'data_type' => 'text'
            ],
        ];

        return $data;
    }

}
