<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterAssetResponsible extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('assets', function (Blueprint $table) {

            $table->dropColumn('responsible');
        });

        Schema::table('assets', function (Blueprint $table) {

            $table->integer('responsible')->unsigned()->nullable();
            $table->foreign('responsible')->references('id')->on('collaborators');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('assets', function (Blueprint $table) {

            $table->dropForeign('assets_responsible_foreign');
            $table->dropColumn('responsible');
        });

        Schema::table('assets', function (Blueprint $table) {

            $table->string('responsible')->nullable();
        });
    }


}
