<?php

namespace Modules\Assets\Console;

use Illuminate\Console\Command;
use Modules\Asset\Service\AssetStatusLogService;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputArgument;

class GenerateStatusLog extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'assets-status-log:generate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command to generate logs from status.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {

        $assetStatusLogService = \App::make(AssetStatusLogService::class);

        $assetStatusLogService->generateLog();

    }

    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return [];
    }

    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        return [];
    }
}
